library(raster)
library(scales)

i_site = 'Paulina'
for(i_site in c('Ritthem','Paulina','Hellegat','Viane')){

  figureDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 1 - Bivalve survey maps/Figure components/'
  csvDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 1 - Bivalve survey maps/CSV/'
  NDVIDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 1 - Bivalve survey maps/NDVI/'
  AHNDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 1 - Bivalve survey maps/AHN/'
  AHNSiteDirectory = paste(AHNDirectory,i_site,' AHN/', sep = '')
  
  # GPS Coordinate information
  if(i_site == 'Viane'){
    
    setwd(NDVIDirectory)
    NDVI = raster('g_Oosterschelde_2016_NDVI_Viane.tif')
    extend(NDVI, c(60561, 61603, 404603, 405077))
    NDVI[is.na(NDVI)] = 0
    yPos = 404880
    xPos = 60650
    main = 'Viane'
    xlim = c(60620,405000)
    breaks = c(-1,0.1,1)
    scaleBarxy = c(61470, 404650)
    
    pch = c(21,21,22)
    bg = alpha(c('khaki','green','grey'),0.5)
    col = alpha(c('khaki','darkgreen','black'),1)
    
    setwd(AHNSiteDirectory)
    r1 = raster(dir(pattern = '.tif')[1])
    r2 = raster(dir(pattern = '.tif')[2])
    r3 = merge(r1,r2)
    r4 = crop(r3, NDVI)
    
    d = read.csv('inundationDuration_perc.csv')
    e = read.csv('elevation_cm.csv')
    inundationFreq = d$V4
    elevation.cm = e$V4
    elevation.m = elevation.cm/100
    M = as.matrix(r4)
    
  } else if (i_site == 'Paulina'){
    
    setwd(NDVIDirectory)
    NDVI = raster('v_Westerschelde_2010_NDVI_Paulina.tif')
    yPos = 375100
    xPos = 38825
    main = 'Paulina'
    xlim = c(38800,39600)
    breaks = c(-0.16,0.1,1)
    scaleBarxy = c(39450, 375250)
    
    pch = c(21,23,22)
    bg = alpha(c('green', 'black','grey'),0.5)
    col = alpha(c('darkgreen','black','black'),1)
    
    setwd(AHNSiteDirectory)
    r1 = raster(dir(pattern = '.tif')[1])
    r2 = raster(dir(pattern = '.tif')[2])
    r3 = merge(r1,r2)
    r4 = crop(r3, NDVI)
    d = read.csv('inundationDuration_perc.csv')
    e = read.csv('elevation_cm.csv')
    inundationFreq = d$V3
    elevation.cm = e$V3
    elevation.m = elevation.cm/100
    M = as.matrix(r4)
    
  } else if (i_site == 'Ritthem'){
    
    setwd(NDVIDirectory)
    NDVI = raster("g_Westerschelde_2004_NDVI_Ritthem.tif")
    NDVI = extend(NDVI, extent(NDVI) + c(0,0,-50,0))
    NDVI[is.na(NDVI)] = 0
    yPos = 386800
    xPos = 34615
    main = 'Ritthem'
    xlim = c(34585,35310)
    breaks = c(-1,0.07,1)
    scaleBarxy = c(35180, 386270)
    
    pch = c(21,21,23)
    bg = alpha(c('khaki','green','black'),0.5)
    col = alpha(c('khaki','darkgreen','black'),1)
    
    setwd(AHNSiteDirectory)
    r1 = raster(dir(pattern = '.tif')[1])
    r2 = raster(dir(pattern = '.tif')[2])
    r3 = merge(r1,r2)
    r4 = crop(r3, NDVI)
    
    d = read.csv('inundationDuration_perc.csv')
    e = read.csv('elevation_cm.csv')
    inundationFreq = d$V4
    elevation.cm = e$V4
    elevation.m = elevation.cm/100
    M = as.matrix(r4)
    
    
  } else if (i_site == 'Hellegat'){
    
    setwd(NDVIDirectory)
    NDVI = raster('g_Westerschelde_2016_NDVI_Hellegat.tif')
    NDVI = extend(NDVI, extent(NDVI) + c(0,0,0,100))
    NDVI[is.na(NDVI)] = 0
    yPos = 376440
    xPos = 55100
    main = 'Hellegat'
    xlim = c(54380,55270)
    breaks = c(-0.16,0.1,1)
    scaleBarxy = c(54430, 376590)
    
    pch = c(21,21,22)
    bg = alpha(c('khaki','green','red'),0.5)
    col = alpha(c('khaki','darkgreen','darkred'),1)
    
    setwd(AHNSiteDirectory)
    r1 = raster(dir(pattern = '.tif')[1])
    r2 = raster(dir(pattern = '.tif')[2])
    r3 = merge(r1,r2)
    r4 = crop(r3, NDVI)
    
    d = read.csv('inundationDuration_perc.csv')
    e = read.csv('elevation_cm.csv')
    inundationFreq = d$V3
    elevation.cm = e$V3
    elevation.m = elevation.cm/100
    M = as.matrix(r4)
  }
  
  # ------------
  
  # --- Recalculate inundation frequency
  i_row = 1
  i_col = 1
  inundFreqM = M
  inundFreqM[] = NA
  for(i_col in 1:dim(M)[2]){
    for(i_row in 1:dim(M)[1]){
      if(!is.na(M[i_row,i_col])){
        inundFreqM[i_row,i_col] = inundationFreq[which.min(abs(M[i_row,i_col] - elevation.m))]
      }
    }
  }
  inundFreqR = setExtent(raster(inundFreqM), ext = extent(r4))
  
  # Plot raster background ----------------------------
  tiff(paste(i_site,'2.tiff', sep = ''), width = 20, height = 20, units = "cm", res = 300)
  
  colPallete = colorRampPalette(alpha(c('white',grey(0.35)),0.5))
  colSeq = colPallete(3)
  plot(NDVI, breaks = breaks, col = colSeq, bty = 'n', 
       xaxt = 'n', yaxt = 'n', box = F,
       main = main, legend = F,
       xlim = xlim)
  contour(inundFreqR, levels = seq(0,100, 10), add = T, vfont = c("sans serif", "bold"),
          labcex = 1.4, col = 1, lwd = 1.5, lty = 3)
  scalebar(d = 100, label = '100 m', xy = scaleBarxy, cex = 1.1)
  
  # Saltmarsh & seagrass mimic survey
  setwd(csvDirectory)
  d = read.csv("Bivalve survey all marshes with AHN inundation.csv")
  d = d[d$site == i_site,]
  d$sample.ID = factor(d$sample.ID)
  d$mass.g[d$species == 'Mytilus edulis' & !is.na(d$length.mm)] = 8.6887e-05 * d$length.mm[d$species == 'Mytilus edulis' & !is.na(d$length.mm)] ^2.8832
  d$mass.g[d$species == 'Crassostrea gigas' & !is.na(d$length.mm)] = 0.0001116122 * d$length.mm[d$species == 'Crassostrea gigas' & !is.na(d$length.mm)] ^2.84053
  d$habitat = factor(d$habitat)
  
  massDensity.g = tapply(d$mass.g, d$sample.ID, sum, na.rm = T)
  sampleArea.m2 = tapply(d$sampleArea.m2, d$sample.ID, unique)
  massDensity.g_m2 = massDensity.g/sampleArea.m2
  habitat = factor(levels(d$habitat)[tapply(d$habitat, d$sample.ID, unique)])
  x = tapply(d$X_RD, d$sample.ID, unique)
  y = tapply(d$Y_RD, d$sample.ID, unique)
  
  pointScaleParameter = 100
  legendSeq = c(1,2,3)
  pointScale = sqrt(massDensity.g_m2/pointScaleParameter)
  points(y[massDensity.g_m2 == 0] ~ x[massDensity.g_m2 == 0], 
         pch = 4, cex = 1, col = 'darkgreen', 
         lwd = 2)
  
  if(i_site == 'Ritthem'){
    bg = alpha(c('green','green','darkblue'),0.5)
    text(y = mean(y) - 200, x = mean(x) - 50, 'Seagrass mimics', cex = 1.2)
    lines(y = c(y[habitat == 'seagrass mimic'][1], mean(y) - 180), x = c(x[habitat == 'seagrass mimic'][1], mean(x) - 60))
    lines(y = c(y[habitat == 'seagrass mimic'][2], mean(y) - 180), x = c(x[habitat == 'seagrass mimic'][2], mean(x) - 30))
  }
  if(i_site == 'Paulina'){
    bg = alpha(c('green','darkblue'),0.5)
    text(y = mean(y) + 200, x = mean(x) - 50, 'Seagrass mimics', cex = 1.2)
    lines(y = c(y[habitat == 'seagrass mimic'][1], mean(y) + 180), x = c(x[habitat == 'seagrass mimic'][1], mean(x) - 60))
  }
  
  points(y ~ x, pch = 21, 
         bg = bg[as.numeric(habitat)],
         col = 1,
         cex = pointScale)
  
  # Legend ---------
  if(i_site == 'Ritthem'){
    legendSeq = c(1,2,3,3.5)
    pointLegend = sqrt(10^legendSeq/pointScaleParameter)
    rect(xleft = xPos, xright = xPos + 150, ybottom = yPos - 50, ytop = yPos + 200, col = 'white')
    offset = c(10, 45,75,110, 170)#seq(-30,110,length.out = 5) 
    
    points(x = rep(xPos + 50, times = 4), y = yPos + offset[2:5] - 50,
           cex = pointLegend,
           pch = 21, bg = alpha('green',0.5), col = 1)#'darkgreen')
    points(x = xPos + 50, y = yPos + 20 - 50,
           pch = 4, cex = 1, col = 'darkgreen', lwd = 2)
    text = c(0,
             expression('10'^'1'),
             expression('10'^'2'),
             expression('10'^'3'),
             expression('10'^'3.5'))
    offset = c(seq(20,115,length.out = 4), 165)
    text(x = xPos + 75, y = yPos + 175, expression(g/m^2), cex = 1.2)
    text(x = rep(xPos + 115, times = 5), 
         y = yPos + offset - 50, 
         cex = 1.2,
         text)
  }
  
  setwd(figureDirectory)
  dev.off()
}
